/*
 * Decompiled with CFR 0.152.
 */
package jace.hardware.mockingboard;

import jace.hardware.mockingboard.PSG;
import java.util.ArrayList;
import java.util.List;

public class Card {
    static final int MAX_OUTPUT = Short.MAX_VALUE;
    static final int MAX_AY8910 = 2;
    static final int CLOCK = 1789770;
    static final int SAMPLE_RATE = 44100;
    private List<PSG> chips = new ArrayList<PSG>();
    public static int[] VolTable;
    int[][] buffers;
    int bufferLength = -1;

    public Card() {
        for (int i = 0; i < 2; ++i) {
            PSG chip = new PSG(1789770, 44100);
            this.chips.add(chip);
        }
    }

    public void writeReg(int chipNumber, int register, int value) {
        Reg r = Reg.get(register);
        this.writeReg(chipNumber, r, value);
    }

    public void writeReg(int chipNumber, Reg register, int value) {
        this.chips.get(chipNumber).writeReg(register, value);
    }

    public void update(int chipNumber, int[][] buffer, int length) {
        this.chips.get(chipNumber).update(buffer, length);
    }

    public int[][] getBuffers(int length) {
        if (this.buffers == null || this.bufferLength != length) {
            this.buffers = new int[3][length];
            this.bufferLength = length;
        }
        return this.buffers;
    }

    public void playSound(int size, int[] left, int[] right) {
        int[][] buffers = this.getBuffers(left.length);
        this.update(0, buffers, size);
        this.mixDown(left, buffers, size);
        this.update(1, buffers, size);
        this.mixDown(right, buffers, size);
    }

    public void mixDown(int[] out, int[][] in, int size) {
        for (int i = 0; i < size; ++i) {
            int sample;
            out[i] = sample = (in[0][i] + in[1][i] + in[2][i]) / 3;
        }
    }

    public void reset(int chipNumber) {
        this.chips.get(chipNumber).reset();
    }

    public void initAll(int nClock, int nSampleRate) {
        for (PSG p : this.chips) {
            p.reset();
        }
    }

    static void buildMixerTable() {
        VolTable = new int[16];
        double out = 32767.0;
        for (int i = 15; i > 0; --i) {
            Card.VolTable[i] = (int)Math.round(out);
            out /= 1.15;
        }
        Card.VolTable[0] = 0;
    }

    static {
        Card.buildMixerTable();
    }

    public static enum Reg {
        AFine(0, 255),
        ACoarse(1, 15),
        BFine(2, 255),
        BCoarse(3, 15),
        CFine(4, 255),
        CCoarse(5, 15),
        NoisePeriod(6, 31),
        Enable(7, 255),
        AVol(8, 31),
        BVol(9, 31),
        CVol(10, 31),
        EnvFine(11, 255),
        EnvCoarse(12, 255),
        EnvShape(13, 15),
        PortA(14, 255),
        PortB(15, 255);

        public final int registerNumber;
        public final int max;
        public static Reg[] preferredOrder;

        private Reg(int number, int maxValue) {
            this.registerNumber = number;
            this.max = maxValue;
        }

        static Reg get(int number) {
            for (Reg r : Reg.values()) {
                if (r.registerNumber != number) continue;
                return r;
            }
            return null;
        }

        static {
            preferredOrder = new Reg[]{Enable, EnvShape, EnvCoarse, EnvFine, NoisePeriod, AVol, BVol, CVol, AFine, ACoarse, BFine, BCoarse, CFine, CCoarse};
        }
    }
}

